IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_CD_ES_Registrar_RF') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_CD_ES_Registrar_RF
END
GO

CREATE PROCEDURE dbo.CPJ_CD_ES_Registrar_RF @pJson VARCHAR(8000)
AS 

/*
 * LOG VERSIONES:
 * 23/08/2022: Se crea el Stored
*/

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug				TINYINT

SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @pJson_A_Enviar		VARCHAR(8000)
DECLARE @Fecha_Desde		DATETIME
DECLARE @Fecha_Desde_VC		VARCHAR(20)
/*FIN Variables Locales*/

SET @Fecha_Desde = DATEADD(MINUTE, -1, GETDATE())

SET @Fecha_Desde_VC	 =	RIGHT('0000' + CAST(DATEPART(YEAR, @Fecha_Desde) AS VARCHAR), 4) + 
						'-' +
						RIGHT('00' + CAST(DATEPART(MONTH, @Fecha_Desde) AS VARCHAR), 2)  + 
						'-' +
						RIGHT('00' + CAST(DATEPART(DAY, @Fecha_Desde) AS VARCHAR), 2) +
						'T' +
						RIGHT('00' + CAST(DATEPART(HOUR, @Fecha_Desde) AS VARCHAR), 2) + 
						':' +
						RIGHT('00' + CAST(DATEPART(MINUTE, @Fecha_Desde) AS VARCHAR), 2) + 
						':' +
						'00'

SET @pJson_A_Enviar =	'{' + 
						dbo.CF_Json_ParsearVariable('ModoDebug', '1', 'INTEGER') + ',' + 
						dbo.CF_Json_ParsearVariable('API_Metodo', 'suprema_rf_events', 'INTEGER') + ',' + 
						'"API_Data":{"fecha_desde":"' + @Fecha_Desde_VC + '"}' +
						'}'

EXEC dbo.CPJ_CleverAPI_Ejecutar @pJson_A_Enviar

--EXEC dbo.CPJ_CD_ES_Registrar_RF '{"ModoDebug":"1"}'